/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Config;
import util.Logger;
import view.MainView;

public class Inputformat
extends JDialog {
    static Logger logger = Logger.getLogger();
    private static final long serialVersionUID = 1L;
    private Action confirmAction;
    private Action cancelAction;
    private Config myConfig;
    private JTextField CommentText;
    private JTextField SeparatorText;
    private JTextField CategoryText;
    private JTextField PosTargetText;
    private JTextField PosFreqText;
    private JTextField PosAziText;
    private JTextField PosRealXText;
    private JTextField PosRealYText;
    private JTextField PosImagXText;
    private JTextField PosImagYText;

    public Inputformat(MainView pmw) {
        super(pmw, "Format of Input Data", true);
        logger.entry(4, "Inputformat.Inputformat");
        this.myConfig = Config.getConfig();
        this.createActions();
        this.createControls();
        this.pack();
        logger.exit(4, "Inputformat.Inputformat");
    }

    private void createActions() {
        logger.entry(4, "Header.createActions");
        this.confirmAction = new AbstractAction("O.K."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Inputformat.this.confirm();
            }
        };
        this.cancelAction = new AbstractAction("Cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Inputformat.this.setVisible(false);
            }
        };
        logger.exit(4, "Header.createActions");
    }

    private void createControls() {
        logger.entry(4, "Header.createControls");
        JPanel controlpanel = new JPanel();
        controlpanel.setLayout(new BoxLayout(controlpanel, 1));
        Box databox = new Box(0);
        Box innerbox = new Box(0);
        JPanel leftpanel = new JPanel(new GridLayout(0, 1, 5, 5));
        JPanel rightpanel = new JPanel(new GridLayout(0, 1, 5, 5));
        leftpanel.add(new JLabel("Character of Comment:"));
        this.CommentText = new JTextField(2);
        this.CommentText.setText(this.myConfig.getParam("Comment"));
        rightpanel.add(this.CommentText);
        leftpanel.add(new JLabel("Character of Separator:"));
        this.SeparatorText = new JTextField(2);
        this.SeparatorText.setText(this.myConfig.getParam("Separator"));
        rightpanel.add(this.SeparatorText);
        leftpanel.add(new JLabel("Position of Category:"));
        this.CategoryText = new JTextField(2);
        this.CategoryText.setText(this.myConfig.getParam("PosCategory"));
        rightpanel.add(this.CategoryText);
        leftpanel.add(new JLabel("Position of Target Angle:"));
        this.PosTargetText = new JTextField(2);
        this.PosTargetText.setText(this.myConfig.getParam("PosTarget"));
        rightpanel.add(this.PosTargetText);
        leftpanel.add(new JLabel("Position of Frequency:"));
        this.PosFreqText = new JTextField(2);
        this.PosFreqText.setText(this.myConfig.getParam("PosFreq"));
        rightpanel.add(this.PosFreqText);
        leftpanel.add(new JLabel("Position of Azimuth:"));
        this.PosAziText = new JTextField(2);
        this.PosAziText.setText(this.myConfig.getParam("PosAzi"));
        rightpanel.add(this.PosAziText);
        this.PosRealXText = new JTextField(2);
        this.PosRealXText.setText(this.myConfig.getParam("PosRealX"));
        this.PosRealYText = new JTextField(2);
        this.PosRealYText.setText(this.myConfig.getParam("PosRealY"));
        this.PosImagXText = new JTextField(2);
        this.PosImagXText.setText(this.myConfig.getParam("PosImagX"));
        this.PosImagYText = new JTextField(2);
        this.PosImagYText.setText(this.myConfig.getParam("PosImagY"));
        if (this.myConfig.getParam("Unused01").equals("4711")) {
            leftpanel.add(new JLabel("Position of Real X:"));
            rightpanel.add(this.PosRealXText);
            leftpanel.add(new JLabel("Position of Real Y:"));
            rightpanel.add(this.PosRealYText);
            leftpanel.add(new JLabel("Position of Imag X:"));
            rightpanel.add(this.PosImagXText);
            leftpanel.add(new JLabel("Position of Imag Y:"));
            rightpanel.add(this.PosImagYText);
        }
        leftpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        innerbox.add(leftpanel);
        innerbox.add(rightpanel);
        innerbox.setBorder(BorderFactory.createTitledBorder("Data Format"));
        databox.add(innerbox);
        databox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        controlpanel.add(databox);
        JPanel acceptpanel = new JPanel(new GridLayout(0, 2, 5, 5));
        JButton OkButton = new JButton(this.confirmAction);
        JButton CancelButton = new JButton(this.cancelAction);
        acceptpanel.add(OkButton);
        acceptpanel.add(CancelButton);
        acceptpanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        controlpanel.add(acceptpanel);
        this.add(controlpanel);
        logger.exit(4, "Header.createControls");
    }

    private void confirm() {
        logger.entry(4, "Header.confirm");
        this.myConfig.setParam("Comment", this.CommentText.getText());
        this.myConfig.setParam("Separator", this.SeparatorText.getText());
        this.myConfig.setParam("PosCategory", this.CategoryText.getText());
        this.myConfig.setParam("PosTarget", this.PosTargetText.getText());
        this.myConfig.setParam("PosFreq", this.PosFreqText.getText());
        this.myConfig.setParam("PosAzi", this.PosAziText.getText());
        this.myConfig.setParam("PosRealX", this.PosRealXText.getText());
        this.myConfig.setParam("PosRealY", this.PosRealYText.getText());
        this.myConfig.setParam("PosImagX", this.PosImagXText.getText());
        this.myConfig.setParam("PosImagY", this.PosImagYText.getText());
        this.setVisible(false);
        logger.exit(4, "Header.confirm");
    }
}

